//-------------------------------------------------------------------------------------
// SID Monitor - Utility for Sudden Ionospheric Disturbances Monitoring Stations
// Copyright (C) 2006 - Lionel Loudet
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//-------------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using WeifenLuo.WinFormsUI;

namespace SID_monitor
{
    public partial class SIDEventsViewerDockablePanel : DockContent
    {
        // sidEventsViewer... methods signature
        public delegate DataRow NewRowDelegate();
        public delegate void AddDataTableEventsRowDelegate(SIDEvents.DataTableEventsRow row);
        public delegate void ClearSelectionDelegate();

        // declaration of the public methods
        public NewRowDelegate NewRow;
        public AddDataTableEventsRowDelegate AddDataTableEventsRow;
        public ClearSelectionDelegate ClearSelection;


        public SIDEventsViewerDockablePanel()
        {
            InitializeComponent();

            // definition of the public methods
            NewRow = this.sidEventsViewer.SIDEventsDataTable.NewRow;
            AddDataTableEventsRow = this.sidEventsViewer.SIDEventsDataTable.AddDataTableEventsRow;
            ClearSelection = this.sidEventsViewer.ClearSelection;
        }

        #region Public Methods
        public void ClearDataTable()
        {
            // Clears the events list
            this.sidEventsViewer.SIDEventsDataTable.Clear();
        }
        #endregion

        #region Properties
        public DataGridViewSelectedRowCollection SelectedRows
        {
            get
            {
                return this.sidEventsViewer.SelectedRows;
            }
        }

        public DataGridViewRowCollection Rows
        {
            get
            {
                return this.sidEventsViewer.Rows;
            }
        }

        public bool AllowUserToAddRows
        {
            get
            {
                return this.sidEventsViewer.AllowUserToAddRows;
            }
            set
            {
                this.sidEventsViewer.AllowUserToAddRows = value;
            }
        }

        public bool ReadOnly
        {
            get
            {
                return this.sidEventsViewer.ReadOnly;
            }
            set
            {
                this.sidEventsViewer.ReadOnly = value;
            }
        }

        public bool EnableContextMenu
        {
            get
            {
                return this.sidEventsViewer.EnableContextMenu;
            }
            set
            {
                this.sidEventsViewer.EnableContextMenu = value;
            }
        }

        public bool RowHeadersVisible
        {
            get
            {
                return this.sidEventsViewer.RowHeadersVisible;
            }
            set
            {
                this.sidEventsViewer.RowHeadersVisible = value;
            }
        }

        public DataGridViewSelectionMode SelectionMode
        {
            get
            {
                return this.sidEventsViewer.SelectionMode;
            }
            set
            {
                this.sidEventsViewer.SelectionMode = value;
            }
        }

        public SIDEvents.DataTableEventsDataTable SIDEventsDataTable
        {
            get
            {
                return this.sidEventsViewer.SIDEventsDataTable;
            }
        }
        #endregion

        #region Events
        /// <summary>
        /// DataModified Event
        /// </summary>

        public event EventHandler DataModified;  // dataGridView content has changed

        protected virtual void OnDataModified(EventArgs e)
        {
            EventHandler handler = DataModified;
            if (handler != null)
            {
                // Invokes the delegates. 
                handler(this, e);
            }
        }

        /// <summary>
        /// AddEventRequested Event
        /// </summary>

        public event EventHandler AddEventRequested;  // AddEvent is requested

        protected virtual void OnAddEventRequested(EventArgs e)
        {
            EventHandler handler = AddEventRequested;
            if (handler != null)
            {
                // Invokes the delegates. 
                handler(this, e);
            }
        }

        /// <summary>
        /// EditEventRequested Event
        /// </summary>

        public event EventHandler EditEventRequested;  // EditEvent is requested

        protected virtual void OnEditEventRequested(EventArgs e)
        {
            EventHandler handler = EditEventRequested;
            if (handler != null)
            {
                // Invokes the delegates. 
                handler(this, e);
            }
        }

        /// <summary>
        /// DeleteEventRequested Event
        /// </summary>

        public event EventHandler DeleteEventRequested;  // AddEvent is requested

        protected virtual void OnDeleteEventRequested(EventArgs e)
        {
            EventHandler handler = DeleteEventRequested;
            if (handler != null)
            {
                // Invokes the delegates. 
                handler(this, e);
            }
        }


        public event EventHandler SelectionChanged;

        protected virtual void OnSelectionChanged(EventArgs e)
        {
            EventHandler handler = SelectionChanged;
            if (handler != null)
            {
                // Invokes the delegates. 
                handler(this, e);
            }
        }
        #endregion

        #region  sidEventsViewer Events Handling
        private void sidEventsViewer_SelectionChanged(object sender, EventArgs e)
        {
            OnSelectionChanged(e);
        }


        private void sidEventsViewer_AddEventRequested(object sender, EventArgs e)
        {
            OnAddEventRequested(e);
        }

        private void sidEventsViewer_DataModified(object sender, EventArgs e)
        {
            OnDataModified(e);
        }

        private void sidEventsViewer_DeleteEventRequested(object sender, EventArgs e)
        {
            OnDeleteEventRequested(e);
        }

        private void sidEventsViewer_EditEventRequested(object sender, EventArgs e)
        {
            OnEditEventRequested(e);
        }
        #endregion

    }
}
